%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Erzeuge_Profile.m
    %   Das Programm liest die relevanten Daten aus der TXT-Rohdaten-Datei
    %   im XML-Format ein und gleicht die Eingangsdaten mit den Daten in 
    %   der Datei"Streckenparameter.xlsx" ab. Diese muss zuvor angelegt 
    %   sein. Die eingelesenen Daten werden als Rohdateien in den Ordner 
    %   "00_HLP_RAW" abgespeichert, der sich im Ordner "Results" befindet.
%   Version 1.1
%   14.05.2024
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
clear all

% Definiere Standort Rohdaten
loc_script=pwd;
loc_raw=[loc_script(1:end-22),'Rohdaten\'];

% Gebe dem Nutzer Zugriff auf die Rohdaten (txt-Datei im XML-Format)
[FileName01,PathName01] = uigetfile('*.txt','Importiere txt-Rohdaten aus Messung',loc_raw);
% Streckenparameter werden automatisch mitgelesen
FileName02='Streckenparameter.xlsx';

% Importiere relevante Parameter aus der Rohdaten-Datei
[messfahrt_nr,distanz,breitengrad,laengengrad,hoehe,hlp,fs,lfdm]=importfunktion([PathName01,'\',FileName01]);
% Importiere Streckenparameter
[Messdatum, Fahrt, Messfahrtnummer, Messfahrtid, Streckenliste, FS]=importiere_uebersicht([PathName01,'\',FileName02]);


% Bestimme die Messfahrt_ID und bilde den Messfahrt_ID-Vektor
n_Mfnr = size(Messfahrtnummer,1);
TF = zeros(n_Mfnr,1);
for k = 1:size(Messfahrtnummer,1)
    TF(k) = contains(Messfahrtnummer(k),messfahrt_nr);
end
TF = logical(TF);
mf_id = Messfahrtid(TF);
messfahrt_ID = mf_id*ones(length(distanz),1);


% Sortiere die Daten nach der gemessenen Laufkoordinate des Fahrzeugs (Die
% Messdaten knnen unter Umstnden in der CSV Datei chaotisch angeordnet
% sein)

[~,dist_id]=sort(distanz,'ascend');
messfahrt_ID=messfahrt_ID(dist_id);
distanz=distanz(dist_id);
breitengrad=breitengrad(dist_id);
laengengrad=laengengrad(dist_id);
hoehe=hoehe(dist_id);
hlp=hlp(dist_id);
lfdm = lfdm(dist_id);

% Identifiziere welche Messfahrt-IDs aus der csv-Datei in der Streckenliste
% auftauchen und sortiere die zugehrigen Streckennamen und
% Fahrstreifennummern aus

msf_liste=unique(messfahrt_ID);

fs=zeros([size(msf_liste,1) 1]);
strecke=strings([size(msf_liste,1) 1]);

for m=1:size(msf_liste,1)
    fs(m,:)=FS(Messfahrtid==msf_liste(m));
    strecke(m,:)=Streckenliste(Messfahrtid==msf_liste(m));
    
end

fs_liste=unique(fs);
streckenname=unique(strecke);

% Definiere den Zielpfad zum Speichern der Hhenlngsprofile 
% (im Rohformat, GPS-basiert und ohne Streckenkoordinaten) 

Zielpfad=[loc_script(1:end-22),'Results\',convertStringsToChars(streckenname),'\'];
mkdir(Zielpfad)

for k=1:size(fs_liste,1)
    Unterverz=['FS',num2str(fs_liste(k),'%02d'),'\00_HLP_RAW\'];
    mkdir([Zielpfad,Unterverz]);    
end

% Speichere die Hhenwerte mit GPS_Koordinaten ins Zielverzeichnis,
% getrennt nach Messfahrten und Fahrstreifen 

for m=1:size(msf_liste,1)
    if ~isempty(breitengrad((messfahrt_ID==msf_liste(m))))

        Distanz_Messfahrzeug=distanz((messfahrt_ID==msf_liste(m)));
        GPS_Breite=breitengrad((messfahrt_ID==msf_liste(m)));
        GPS_Laenge=laengengrad((messfahrt_ID==msf_liste(m)));
        GPS_Hoehe=hoehe((messfahrt_ID==msf_liste(m)));
        HLP_Wert=hlp((messfahrt_ID==msf_liste(m)));
        LfdM=lfdm((messfahrt_ID==msf_liste(m)));
        Fahrstreifen=fs(m,:);
        MESS_ID=msf_liste(m);
        
        Unterverz=['FS',num2str(fs(m,:),'%02d'),'\00_HLP_RAW\'];
                
        Zieldatei01=[convertStringsToChars(streckenname),'_',num2str(MESS_ID,'%03d'),'_FS',num2str(Fahrstreifen),'_HLP_RAW','.mat'];
        matfile1=[Zielpfad,Unterverz,Zieldatei01];
        save(matfile1,'Distanz_Messfahrzeug','GPS_Breite','GPS_Laenge','GPS_Hoehe','HLP_Wert','LfdM','streckenname','Fahrstreifen','MESS_ID')
        
        disp(['Erzeuge: ',matfile1])

        clear Distanz_Messfahrzeug
        clear GPS_Breite
        clear GPS_Laenge
        clear GPS_Hoehe
        clear HLP_Wert
        clear LfdM
        clear Fahrstreifen
        clear MESS_ID
        
    end
end
    
%%% EOF
