function [messfahrtnr,distance1, latitude, longitude, height, l1, fs, lfdmeter] = importfunktion(filename, dataLines)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% If dataLines is not specified, define defaults
if nargin < 2
    dataLines = [1, Inf];
end

%% Setup the Import Options and import the data
opts = delimitedTextImportOptions("NumVariables", 1);

% Specify range and delimiter
opts.DataLines = dataLines;
opts.Delimiter = ";";

% Specify column names and types
opts.VariableNames = ["Var1"];
opts.VariableTypes = ["string"];

% Specify file level properties
opts.ExtraColumnsRule = "ignore";
opts.EmptyLineRule = "read";

tbl0 = readtable(filename, opts);

% Bestimme die Datenzeilen mit den relevanten Daten
N = size(tbl0,1);
DAT = zeros(N,1);
POS = zeros(N,1);
FLG = zeros(N,1);
MID = zeros(N,1);

for k = 1:N
    str = string(tbl0{k,:});
    TF_VLA = contains(str,"<Vorlauf>");
    TF_VLE = contains(str,"</Vorlauf>");
    TF_NLA = contains(str,"<Nachlauf>");
    TF_NLE = contains(str,"</Nachlauf>");
    TF_DAT = contains(str,"</Datenstrom>");
    TF_POS = contains(str,"<WGS LfdM=");
    TF_FLG = contains(str,"<Erfassungsflag");
    TF_MID = contains(str,"<B Nr=");
    
    if TF_VLA==1
        VLA = k+1;
    elseif TF_VLE==1  
        VLE = k-1;
    elseif TF_NLA==1  
        NLA = k+1;
    elseif TF_NLE==1  
        NLE = k-1;
    elseif TF_DAT==1
        DAT(k-10:k-1,1) = 1;
    elseif TF_POS==1
        POS(k) = 1;
    elseif TF_FLG==1
        FLG(k) = 1;
    elseif TF_MID==1
        MID(k) = 1;
    end
end    

DAT = logical(DAT);
POS = logical(POS);
FLG = logical(FLG);
MID = logical(MID);

Dat = tbl0(DAT,1);
Pos = tbl0(POS,1);
Flg = tbl0(FLG,1);
Mid = tbl0(MID,1);
Vlf = tbl0(VLA:VLE,1);
Nlf = tbl0(NLA:NLE,1);

N_Vlf = size(Vlf,1);
N_Dat = size(Dat,1);
N_Nlf = size(Nlf,1);
N_Pos = size(Pos,1);
N_Flg = size(Flg,1);
N_Mid = size(Mid,1);

% Extrahiere die relevanten Daten  

for k = 1:N_Dat
        str = char(Dat{k,:});
        n = strfind(str,">");
        m = strfind(str,"<");
        dat(k,:) = str2num(str(n(1)+1:m(2)-1));
end
for k = 1:N_Vlf
        str = char(Vlf{k,:});
        n = strfind(str,">");
        m = strfind(str,"<");
        vlf(k,:) = str2num(str(n(1)+1:m(2)-1));
end
for k = 1:N_Nlf
        str = char(Nlf{k,:});
        n = strfind(str,">");
        m = strfind(str,"<");
        nlf(k,:) = str2num(str(n(1)+1:m(2)-1));
end
for k = 1:N_Pos
        str = char(Pos{k,:});
        nW = strfind(str,"LfdM=");
        mW = strfind(str,"Datum=");
        LfdM(k,1) = str2num(str(nW+6:mW-3));
        nL = strfind(str,"L=");
        nB = strfind(str,"B=");
        nG = strfind(str,"Genauigkeit=");
        nH = strfind(str,"H_NN=");
        nE = strfind(str,"H_WGS=");
        Lon(k,1) = str2num(str(nL+3:nB-3));
        Lat(k,1) = str2num(str(nB+3:nG-3));
        Alt(k,1) = str2num(str(nH+6:nE-3));
end
for k = 1:N_Flg
        str = char(Flg{k,:});
        n = strfind(str,"FS=");
        Fs(k,1) = str2num(str(n+4));
end
for k = 1:N_Mid
        str = char(Mid{k,:});
        n = strfind(str,"D=");
        m = strfind(str,"\B");
        mid(k,1) = string(str(n+3:m-1));
end

hv  = reshape(vlf',[],1);
hm   = reshape(dat',[],1);
hn  = reshape(nlf',[],1);

% Bringe die Daten in das finale Format

l1 = hm;            % Höhenlängsprofil
Ndata = length(hm); % schneide Vor- und Nachlauf ab
Nvorl = length(hv);
dx = 0.1;
distance1 = dx * (0:Ndata-1)'; % Laufkoordinate

X_grob = LfdM - Nvorl*dx; % i.d.R. startet [Lat Lon Alt] bei X_grob = 5m
Y_grob = [LfdM Lat Lon Alt];
Y_fein = interp1(X_grob, Y_grob, distance1,'pchip');

lfdmeter  = Y_fein(:,1);
latitude  = Y_fein(:,2);
longitude = Y_fein(:,3);
height    = Y_fein(:,4);

% messfahrti,distance1, latitude, longitude, height,l1
messfahrtnr = unique(mid);
fs = unique(Fs);

end

%%% EOF

