function [Datum, Fahrt, Messfahrtnummer, Messfahrtid, Strecke, FS] = importiere_uebersicht(workbookFile, sheetName, dataLines)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% If no sheet is specified, read first sheet
if nargin == 1 || isempty(sheetName)
    sheetName = 1;
end

% If row start and end points are not specified, define defaults
if nargin <= 2
    dataLines = [2, 147];
end

%% Setup the Import Options and import the data
opts = spreadsheetImportOptions("NumVariables", 6);

% Specify sheet and range
opts.Sheet = sheetName;
opts.DataRange = "A" + dataLines(1, 1) + ":F" + dataLines(1, 2);

% Specify column names and types
opts.VariableNames = ["Datum", "Fahrt", "Messfahrtnummer", "Messfahrtid", "Strecke", "FS"];
opts.VariableTypes = ["datetime", "double", "string", "double", "string", "double"];

% Specify variable properties
opts = setvaropts(opts, ["Messfahrtnummer", "Strecke"], "WhitespaceRule", "preserve");
opts = setvaropts(opts, ["Messfahrtnummer", "Strecke"], "EmptyFieldRule", "auto");
opts = setvaropts(opts, "Datum", "InputFormat", "");

% Import the data
tbl = readtable(workbookFile, opts, "UseExcel", false);

%% Convert to output type
Datum = tbl.Datum;
Fahrt = tbl.Fahrt;
Messfahrtnummer = tbl.Messfahrtnummer;
Messfahrtid = tbl.Messfahrtid;
Strecke = tbl.Strecke;
FS = tbl.FS;

end

%%% EOF



