%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Bereite_Daten_vor.m
    %   Bringe das Höhenlängsprofil auf eine Streckenkoordinate und 
    %   synchronisiere die Doppelmessung
%   Version 1.1
%   14.05.2024
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

close all
clear

loc_script=pwd;
loc_data=[loc_script(1:end-28),'Results\'];
[FileName01,PathName01] = uigetfile('*.mat','Importiere Profile aus 00_HLP_RAW',loc_data,'Multiselect','on');

Zielpfad=[PathName01(1:end-11),'01_HLP_SNC\'];
mkdir(Zielpfad)

if isa(FileName01,'char')
    disp('Bitte 2 Messungen auswählen')

else
    FileNum = size(FileName01,2);
    
    DST_MSFZ=cell([FileNum 1]);
    BGG=cell([FileNum 1]);
    LGG=cell([FileNum 1]);
    HGG=cell([FileNum 1]);
    HLP=cell([FileNum 1]);
    LfM = cell([FileNum 1]);
    FAHRT_ID=zeros([FileNum 1]);
    RP1=zeros([FileNum 3]);
    
    disp(['Anzahl an Profilen unter gleichen Bedingungen: ',num2str(FileNum)])
    
    % Sammle alle Dateien unter gleichen Bedingungen und führe die
    % Informationen zusammen
    
    for dt = 1:FileNum
        
        Quelldatei=FileName01{dt};
        load([PathName01,Quelldatei])
        
        DST_MSFZ{dt}=Distanz_Messfahrzeug;
        BGG{dt}=GPS_Breite;
        LGG{dt}=GPS_Laenge;
        HGG{dt}=GPS_Hoehe;
        HLP{dt}=HLP_Wert;
        LfM{dt}=LfdM;
        
        % Ermittle Mittelpunkt der GPS-Koordinaten als potentieller
        % Referenzpunkt für die Transformation ins lokale Koordinatensystem
        
        RP1(dt,:)=[mean(GPS_Breite),mean(GPS_Laenge),mean(GPS_Hoehe)];
        FAHRT_ID(dt,:)=MESS_ID;
        
        clear Distanz_Messfahrzeug
        clear GPS_Breite
        clear GPS_Laenge
        clear GPS_Hoehe
        clear HLP_Wert
        clear LfdM
        
    end
    
    % Definiere einen GPS-Referenzpunkt für die Transformation aufs lokale
    % Koordinatensystem auf Basis der zuvor ermittelten Einzelwerte
    REFERENZ_GPS_PUNKT=mean(RP1,1);
    
    X01=cell([FileNum 1]);
    Y01=cell([FileNum 1]);
    Distanz_GPS=cell([FileNum 1]);
    
    POT_STP=zeros([FileNum 3]);
    POT_ETP=zeros([FileNum 3]);
    
    % Definiere wieviel Strecke in den Randbereichen von der Messung verworfen
    % werden soll (An- und Ausfahrbereich)
    Vorlauf_sync=100; % m - Verworfene Bereiche für das Setzen der Passpunkte (Grobsynchronisation)
    Vorlauf_ausw=150; % m - Zusätzlich verworfene Bereiche für die Feinsynchronisation (muss > Vorlauf_sync)
    EVAL_LEN=20; % m - Fensterlänge WLP, Offset für das lokale Koordinatensystem
    
    for dt = 1:FileNum
        
        % Transformiere die GPS-Koordinaten in ein kartesisches System mit
        % metrischer Einheit und einem Referenzpunkt, bereinige die GPS Daten von Messfehlern
        [X01{dt},Y01{dt}]=bereinige_gps(BGG{dt},LGG{dt},HGG{dt},REFERENZ_GPS_PUNKT);
        Distanz_GPS{dt}=[0;cumsum(bsxfun(@hypot,(X01{dt}(2:end,:)-X01{dt}(1:end-1,:)),(Y01{dt}(2:end,:)-Y01{dt}(1:end-1,:))))];
        
        % Finde die GPS-Koordindaten und individuellen Streckenkoordinaten
        % der Start und Endpunkte der auszuwertenden Bereiche
        
        st_ind=find(Distanz_GPS{dt}>=Vorlauf_sync,1,'first');
        sl_ind=find(Distanz_GPS{dt}(end)-Distanz_GPS{dt}>=Vorlauf_sync,1,'last');
        
        POT_STP(dt,:)=[X01{dt}(st_ind),Y01{dt}(st_ind),Distanz_GPS{dt}(st_ind)];
        POT_ETP(dt,:)=[X01{dt}(sl_ind),Y01{dt}(sl_ind),Distanz_GPS{dt}(sl_ind)];
        
    end
    
    %%%%%%%%%%%%%%%%%%%%% Synchronisierung mehrerer Messungen %%%%%%%%%%%%%
    % Konstruiere eine Referenzachse, auf die alle Messachsen hingeschoben
    % werden
    Offset_laufkoord=Vorlauf_sync-Vorlauf_ausw;
    [X_REF,Y_REF,LAUFKOORD] = konstruiere_Referenzachse(POT_STP,POT_ETP,X01,Y01,Distanz_GPS,Offset_laufkoord);
    REF_LAENG=sum(bsxfun(@hypot,X_REF(1:end-1)-X_REF(2:end),Y_REF(1:end-1)-Y_REF(2:end)));
    
    % Verschiebe die GPS-Punkte der einzelnen Messungen auf die
    % Referenzachse und ordne Ihnen die Streckenkoordinate der
    % Referenzachse zu
    
    X01_PROJ=cell([FileNum 1]);
    Y01_PROJ=cell([FileNum 1]);
    LFKOORD=cell([FileNum 1]);
    
    for dt=1:FileNum
        
        [X01_PROJ{dt},Y01_PROJ{dt}] = projiziere_referenz(X01{dt},Y01{dt},X_REF,Y_REF);
        
        % Suche den Punkt, der am nächsten an X_REF(1),Y_REF(1) ist und
        % setze seine Laufkoordinate auf LFKOORD = "min(dist_test)" - 10m. 
        % Definiere von diesem Punkt aus alle LFKOORD nach hinten und vorn 
        [LFKOORD{dt}]=Streckenkoordinaten(X_REF(1),Y_REF(1),X01_PROJ{dt},Y01_PROJ{dt});
        
        % Beschneide die LFKOORD und HLP auf <-100m bis REF_LAENG+100m
        HLP{dt}(LFKOORD{dt}>(REF_LAENG+Vorlauf_sync))=[];
        HLP{dt}(LFKOORD{dt}<-Vorlauf_sync)=[];
        LfM{dt}(LFKOORD{dt}>(REF_LAENG+Vorlauf_sync))=[];
        LfM{dt}(LFKOORD{dt}<-Vorlauf_sync)=[];
        LFKOORD{dt}(LFKOORD{dt}>(REF_LAENG+Vorlauf_sync))=[];
        LFKOORD{dt}(LFKOORD{dt}<-Vorlauf_sync)=[];   
        disp(['Korrektur von Profil Nr.: ',num2str((dt))])
        disp(['Berechne die Streckenkoordinaten von Profil Nr.: ',num2str(dt)])
        
    end
    
    % Verschiebe die Daten auf ein einheitliches Koordinatensystem
        
    H00=cell([FileNum 1]);
    LfM00=cell([FileNum 1]);
    LFKG=cell([FileNum 1]);
    OFFSW=cell([FileNum-1 1]);
    OFFS_QUALI=cell([FileNum-1 1]);
    REFPOINTS=cell([FileNum-1 1]);
    SLS_KOORD=zeros([FileNum 1]);
    
    % Vor LP-Interpolation bestimme gemeinsamen Anfangs- und Endpunkt von LAUFKOORD
    [LAUFKOORD,istart1] = gemeinsame_Laufkoordinate(LFKOORD,LAUFKOORD);
    
    % Führe die Verschiebung auf ein einheitliches Koordinatensystem aus
    for k=1:FileNum
        H00{k}=interp1(LFKOORD{k},HLP{k},LAUFKOORD,'pchip');
        LfM00{k}=interp1(LFKOORD{k},LfM{k},LAUFKOORD,'pchip');
    end

    % Feinsynchronisierung per Kreuzkorrelation
    % Profil Nr. 1 dient als Referenzprofil
    
    LFKG{1}=LAUFKOORD;
    SLS_KOORD(1,:)=LAUFKOORD(end);
    
    % feinsynchronisierte Laufkoordinaten LFKG{k} der übrigen Messungen
    for k=2:FileNum
        [LFKG{k},OFFSW{k-1},OFFS_QUALI{k-1},REFPOINTS{k-1}]=feinsynchronisation(LAUFKOORD,H00{1},H00{k});       
    end
    
    % Vor LP-Interpolation bestimme gemeinsamen Anfangs- und Endpunkt von LAUFKOORD
    [LAUFKOORD,istart2] = gemeinsame_Laufkoordinate(LFKG,LAUFKOORD);
 
    % Setze neues Einheitskoordinatensystem auf Basis des Nullpunktes
    % (Vorlauf für die Grobsnychronisierung und für die
    % Feinsynchronisierung) - Es wird eine halbe Fensterbreite für die
    % WLP-Auswertung zu Beginn übrig gelassen
    
    istart = istart1+istart2-1;
    iend   = istart+size(LAUFKOORD,1)-1;
    REFKOORD=LAUFKOORD-(LAUFKOORD(1)+EVAL_LEN/2);
    X_LOKAL=X_REF(istart:iend);
    Y_LOKAL=Y_REF(istart:iend);
    Auswertelaenge = REFKOORD(end) - EVAL_LEN/2;

    
    for k=1:size(HLP,1)
        
        % Interpoliere die Höhenwerte über das neu gesetzte
        % Koordinatensystem
        hs0=interp1(LFKG{k},H00{k},LAUFKOORD,'pchip');
        lfm=interp1(LFKG{k},LfM00{k},LAUFKOORD,'pchip');
          
        % Eliminiere mögliche offene Fugen
        hs = eliminiere_fugen(hs0')';
        
        %------- Dokumentiere Fugen im Längsprofil ------------------------
        ind = find((hs-hs0)>2*10^-3); % mögliche Fugenorte
        nind = ones(size(ind));
        REFKOORD_Fug_Elim = REFKOORD(ind);
        %------------------------------------------------------------------
        % Speichere die synchronisierten Daten ab
        Zieldatei=[convertStringsToChars(streckenname),'_',num2str(FAHRT_ID(k),'%03d'),'_FS',num2str(Fahrstreifen),'_HLP_SNC','.mat'];
        matfile1=[Zielpfad,Zieldatei];
        save(matfile1,'REFKOORD','REFKOORD_Fug_Elim','hs','lfm','REFERENZ_GPS_PUNKT','X_LOKAL','Y_LOKAL')
        disp(['Erzeuge: ',matfile1])
        %------------------------------------------------------------------
        fig = figure;
        plot(REFKOORD,hs0,'r'),grid
        hold on
        plot(REFKOORD,hs,'b')
        y1 = ylim;
        hold on
        Fuge = stem(REFKOORD_Fug_Elim,y1(1)*nind,'k--');
        hold on
        stem(REFKOORD_Fug_Elim,y1(2)*nind,'k--')
        if isempty(ind)==0
            lgd = legend(Fuge,'Fugenbereinigung','Location','North');
        end
        xlabel('Weg [m]','FontSize',12)
        ylabel('Höhe [m]','FontSize',12)
        title(['Längsprofil  ',strrep(Zieldatei(1:end-12),'_','-')],'FontSize',12);
        
        saveas (fig,[Zielpfad,'GR_',Zieldatei(1:end-12),'.png'],'png')
        saveas (fig,[Zielpfad,'GR_',Zieldatei(1:end-12),'.fig'],'fig')

        clear hs lfm  
    end
    
    % Speichere Feinsynchronisierungsreport und Streckeninformationen
    
    GL_Zieldatei=['Feinsynchronisierungsreport.mat'];
    matfile2=[Zielpfad,GL_Zieldatei];
    save(matfile2,'OFFSW','OFFS_QUALI','REFPOINTS')
    disp(['Erzeuge: ',matfile2])
    
    Strecke_Zieldatei=['Streckeninformationen.mat'];
    matfile3=[Zielpfad(1:end-11),Strecke_Zieldatei];
    save(matfile3,'Auswertelaenge','FAHRT_ID','Fahrstreifen','streckenname')
    disp(['Erzeuge: ',matfile3])

end
   
%%% EOF
