function LFKOORD = Streckenkoordinaten(XNULL,YNULL,XASW,YASW)
% Berechne laufende Streckenkoordinaten fr die Profilpunkte
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

LF_DIFF=bsxfun(@hypot,XASW(1:end-1)-XASW(2:end),YASW(1:end-1)-YASW(2:end));

dist_test=bsxfun(@hypot,XASW-XNULL,YASW-YNULL);
wink_test=bsxfun(@atan2,XASW-XNULL,YASW-YNULL);

[~, index] = sort(dist_test);

LFKOORD=zeros([size(LF_DIFF,1)+1 1]);

if sign(wink_test(index(1)))==sign(wink_test(index(2)))
    startind=min(index(1),index(2));
else
    startind=max(index(1),index(2));
end

LFKOORD(startind,:)=dist_test(startind)-10;
if startind>1    
    for j=startind-1:-1:1
        LFKOORD(j,:)=LFKOORD(j+1,:)-LF_DIFF(j);
    end
end

for j=startind+1:size(LF_DIFF,1)+1
    LFKOORD(j,:)=LFKOORD(j-1,:)+LF_DIFF(j-1);
end

end

%%% EOF


