
function [finp_X,finp_Y] = bereinige_gps(BGG,LGG,HGG,REFERENZ_PUNKT)
% bereinige_gps korrigiert messtechnisch bedingte Fehler im GPS-Signal und
% verschiebt die GPS-Messpunkte auf das vorgesehene Wegraster
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

[X00T,Y00T]=latlon2local(BGG,LGG,HGG,REFERENZ_PUNKT);

%[X00T,Y00T]=deg2utm(BGG,LGG);
gps_rohpfad=bsxfun(@hypot,X00T(1:end-1)-X00T(2:end),Y00T(1:end-1)-Y00T(2:end));    

% Prfe ob das Delta zwischen zwei GPS-Punkten innerhalb der
% verfahrensbedingten Schranken liegt und sortiere jene Punkte aus, die dem
% Kriterium nicht entsprechen

raster=0.1; % m
abw=0.02; %+/- m

dtl_oben=raster+abw; % m
dtl_unten=raster-abw;% m
    
k=1;
X00_RED(k,1)=X00T(1);
Y00_RED(k,1)=Y00T(1);
for j=1:size(gps_rohpfad,1)
    if ((gps_rohpfad(j)>dtl_unten)&&(gps_rohpfad(j)<dtl_oben)) 
    X00_RED(k+1,1)=X00T(j+1);
    Y00_RED(k+1,1)=Y00T(j+1);
    k=k+1;
    end
end
       
stepLengths = sqrt(sum(diff([X00_RED,Y00_RED],[],1).^2,2));
stepLengths = [0; stepLengths]; % add the starting point
cumulativeLen = cumsum(stepLengths);
finalStepLocs = linspace(0,cumulativeLen(end), size(BGG,1));
finalPathXY = interp1(cumulativeLen, [X00_RED,Y00_RED], finalStepLocs);
finp_X=finalPathXY(:,1);
finp_Y=finalPathXY(:,2);

end

%%% EOF
