function hL = eliminiere_fugen(Profil)
% eliminiere_fugen.m eliminiert Fugen auf Basis einer 0,2m-Referenzlinie
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Basis für die Bildung einer Referenzlinie: 0,2m -Latte
ndata = length(Profil);
dx = 0.1;
evl = 2;
evl2 = evl/2;
nj = ndata - evl;

for j = 1:nj
    curr_data = Profil(j:j+evl);
    for i = 1:evl2                  % Kontaktpunkte vorderer Bereich
        for k = evl2+2:evl+1        % Kontaktpunkte hinterer Bereich
            a = (curr_data(k)-curr_data(i))/((k-i)*dx);
            b = curr_data(k) - (k-1)*a*dx;
            g = b + a*dx*(0:evl);
            d = g - curr_data;
            id = find(d<-10^-5,1); % [m]
            if isempty(id)==1
                p(j)=d(evl2+1);
                break
            end
        end
    end
end

np = length(p);
pcr = ndata - np - evl2;
pL1 = [ones(1,evl2)*p(1) p ones(1,pcr)*p(np)];

% Referenzlinie zur Identifikation von offenen Fugen
pL2 = Profil + pL1; % Lage des Mittenpunktes der 0,2m-Latte

% Finde mögliche offene Fugen
hD = pL2 - Profil;
ind1 = find(hD>2*10^-3); % 2mm = Grenzwert f. extrem kurze Einzelhindernisse

if isempty(ind1)==0
    
    % schließe ersten und letzten Punkt des Profils als Fuge aus
    if ind1(end)==length(Profil)
        ind1(end) = [];
    elseif ind1(1)==1
        ind1(1) = [];
    end
    % wenn es sich um eine Fuge vor einem Profilanstieg handelt
    ind2 = find(Profil(ind1+1)>Profil(ind1-1));
        % dann überprüfe ob die Differenz zum vorangehenden Punkt < -2 mm
        ind3 = find(Profil(ind1(ind2))-Profil(ind1(ind2)-1)<-2*10^-3);
        % und, falls ja, ersetze Fuge durch vorangehenden Punkt
        Profil(ind1(ind2(ind3))) = Profil(ind1(ind2(ind3))-1);
        
    % wenn es sich um eine Fuge nach einem Profilabstieg handelt
    ind4 = find(Profil(ind1+1)<=Profil(ind1-1));
        % dann überprüfe ob die Differenz zum nachfolgenden Punkt < -2 mm
        ind5 = find(Profil(ind1(ind4))-Profil(ind1(ind4)+1)<-2*10^-3);
        % und, falls ja, ersetze Fuge durch den nachfolgenden Punkt
        Profil(ind1(ind4(ind5))) = Profil(ind1(ind4(ind5))+1);
    
end

% Ersetze mögliche NaNs durch Originalwerte
ind5 = isnan(Profil);
Profil(ind5) = pL2(ind5);

% Bereinigtes Profil
hL = Profil;
%%% EOF

