
function [LAUFKOORD_gemein,istart] = gemeinsame_Laufkoordinate(LFKOORD,LAUFKOORD)
    % Vor LP-Interpolation bestimme gemeinsamen Anfangs- und Endpunkt von LAUFKOORD
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    istart = 1;
    iend = length(LAUFKOORD);

    if isa(LFKOORD,'cell')
        FileNum = size(LFKOORD,1);
        ueberv = zeros([FileNum 1]);
        ueberh = zeros([FileNum 1]);
        for k=1:FileNum
            ueberv(k) = LFKOORD{k}(1) - LAUFKOORD(1);
            ueberh(k) = LAUFKOORD(end)-LFKOORD{k}(end);
        end
        Ueberv = max(ueberv);
        Ueberh = max(ueberh);
    else
        Ueberv = LFKOORD(1) - LAUFKOORD(1);
        Ueberh = LAUFKOORD(end)-LFKOORD(end);
    end
    
    if Ueberv>0
        istart = find(LAUFKOORD>=(LAUFKOORD(1)+Ueberv),1,'first');
    end
    if Ueberh>0
        iend = find(LAUFKOORD<=(LAUFKOORD(end)-Ueberh),1,'last');
    end
    
    LAUFKOORD_gemein = LAUFKOORD(istart:iend);

end

%%% EOF


