
function [X_REF,Y_REF,LAUFK] = konstruiere_Referenzachse(POT_STP,POT_ETP,X01,Y01,Distanz_GPS,Offset_laufkoord)
% Konstruiere eine Referenzachse, bestehend aus mehreren Messungen mit GPS Daten
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Ermittle die kürzeste Distanz (bezogen auf die Streckenkoordinaten)
% zwischen den defierten Anfangs (POT_STP)- und Endpunkten (POT_ETP) 

Kombi=zeros([size(POT_STP,1)*size(POT_ETP,1) 2]);
Abstand=zeros([size(POT_STP,1)*size(POT_ETP,1) 1]);

p=1;

for m=1:size(POT_STP,1)
    for n=1:size(POT_ETP,1)
        Kombi(p,:)=[m,n];

        POT_DIST=projiziere_auf_streckenkoordinate(POT_STP(m,1),POT_STP(m,2),X01{n},Y01{n},Distanz_GPS{n});
        Abstand(p,:)=POT_ETP(n,3)-POT_DIST;
        p=p+1;
    end
end

[~,ind_mabst]=min(Abstand);
mabst_komb=Kombi(ind_mabst,:);

SG_STP=POT_STP(mabst_komb(1),:);
SG_ETP=POT_ETP(mabst_komb(2),:);

% Ordne den maßgebenden Start- und Endpunkt den nächstliegenden
% GPS-Koordinaten der einzelnen Messachsen zu sowie die Indizes dieser
% jeweiligen Punkte 

INSTP=zeros([size(X01,1) 1]);
INETP=zeros([size(X01,1) 1]);
STPV=zeros([size(X01,1) 2]);
ETPV=zeros([size(X01,1) 2]);

for dt = 1:size(X01,1)
    [~,ind_nbstp]=min(bsxfun(@hypot,(SG_STP(1,1)-X01{dt}),(SG_STP(1,2)-Y01{dt})));
    [~,ind_nbetp]=min(bsxfun(@hypot,(SG_ETP(1,1)-X01{dt}),(SG_ETP(1,2)-Y01{dt})));
    
    INSTP(dt,:)=ind_nbstp;
    INETP(dt,:)=ind_nbetp;
    
    STPV(dt,:)=[X01{dt}(ind_nbstp),Y01{dt}(ind_nbstp)];
    ETPV(dt,:)=[X01{dt}(ind_nbetp),Y01{dt}(ind_nbetp)];
    
end

% Definiere die Parameter der Referenzachse

Punkteraster=10; %m - alle wieviel m sollen die Passpunkte gesetzt werden
Punktabst=0.1; %m - Raster der Messpunkte auf den Messachsen

zwischenind=round(Punkteraster/Punktabst);
anz_passpunkte=round(min(INETP-INSTP)/zwischenind)+1; %Anzahl aller Passpunkte, inkl. Anfangs- und Endpunkt

X_PASS=zeros([anz_passpunkte 1]);
Y_PASS=zeros([anz_passpunkte 1]);

% Erster Passpunkt

X_PASS(1,:)=mean(STPV(:,1));
Y_PASS(1,:)=mean(STPV(:,2));

% Zwischenpunkte

for k=2:anz_passpunkte-1
    ind_pp=INSTP+(k-1)*zwischenind;
    
    XLOC=zeros([size(X01,1) 1]);
    YLOC=zeros([size(X01,1) 1]);
    
    for dt = 1:size(X01,1)
        XLOC(dt,:)=X01{dt}(ind_pp(dt));
        YLOC(dt,:)=Y01{dt}(ind_pp(dt));        
    end
    
    X_PASS(k,:)=mean(XLOC);
    Y_PASS(k,:)=mean(YLOC);
end

% Letzter Passpunkt

X_PASS(anz_passpunkte,:)=mean(ETPV(:,1));
Y_PASS(anz_passpunkte,:)=mean(ETPV(:,2));

% Länge der Passpunktachse
DELTA=hypot(X_PASS(2:end)-X_PASS(1:end-1),Y_PASS(2:end)-Y_PASS(1:end-1));

% Definition eines lokalen Streckenkoordinatensystems auf Basis der
% Passpunktachse, dabei gilt der 1. Passpunkt als Startpunkt des
% Koordinatensystems, abzüglich des mitgegebenen Offsets

DTLCM=zeros([size(DELTA,1)+1 1]);
DTLCM(1)=Offset_laufkoord;
DTLCM(2:end)=DTLCM(1)+cumsum(DELTA);
LAUFK=(Offset_laufkoord:0.1:sum(DELTA))';
LAUFRGM = interp1(DTLCM, [X_PASS,Y_PASS], LAUFK,'pchip');

X_REF=LAUFRGM(:,1);
Y_REF=LAUFRGM(:,2);

end

%%% EOF

