
function DIST_OUT = projiziere_auf_streckenkoordinate(XASP,YASP,XREF,YREF,DIST_REF)
% Projiziere ausgewhlten GPS-Punkt (ASP) auf Referenzprofil (REF) und
% ermittle die zugehrige Streckenkoordinate
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

dist_test=bsxfun(@hypot,XASP-XREF,YASP-YREF);
[~, index] = sort(dist_test);

P01=[XREF(index(1));YREF(index(1))];
P02=[XREF(index(2));YREF(index(2))];
DST01=DIST_REF(index(1));
DST02=DIST_REF(index(2));
PREF=[XASP;YASP];

if norm(P02-P01)==0
    DIST_OUT=DIST_REF(index(1));
else
    UD=(P02-P01)/norm(P02-P01);
    PPROJ=P01+(UD'*(((PREF-P01)'*UD)/(UD'*UD)))';
    DST_GES=bsxfun(@hypot,P02(1)-P01(1),P02(2)-P01(2));
    DST_PART=bsxfun(@hypot,PPROJ(1)-P01(1),PPROJ(2)-P01(2));
    
    DIST_OUT=DST01+(DST02-DST01)*(DST_PART/DST_GES);    
end

end

%%% EOF

