function [XOUT,YOUT] = projiziere_referenz(XASW,YASW,XREF,YREF)
% Projiziere ausgewhltes Profil (ASW) auf Referenzprofil (REF)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

XOUT=zeros([size(XASW,1) 1]);
YOUT=zeros([size(XASW,1) 1]);

for k=1:size(XASW,1)
    dist_test=bsxfun(@hypot,XASW(k)-XREF,YASW(k)-YREF);
    [~, index] = sort(dist_test);
    
    P01=[XREF(index(1));YREF(index(1))];
    P02=[XREF(index(2));YREF(index(2))];
    PREF=[XASW(k);YASW(k)];
    if norm(P02-P01)==0
        PPROJ=P01;
    else
        UD=(P02-P01)/norm(P02-P01);
        PPROJ=P01+(UD'*(((PREF-P01)'*UD)/(UD'*UD)))';
    end
    
    XOUT(k,:)=PPROJ(1);
    YOUT(k,:)=PPROJ(2);
end

end

%%% EOF



