
function [OFFSW,KFFSW,xm_tst00,laenge_teilstuecke] = versaetze(X01,Y01,Y02)
% ermittle die Verstze fr die Feinsynchronisation
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

anz_mp=size(X01,1)-1; % Lasse den letzten Messpunkt auen vor
aufloesung=mean(diff(X01(1:end-1))); % Profilauflsung m
laenge_teilstuecke=100; % 
vorschub=laenge_teilstuecke/2; % 
vors_aufl=round(vorschub/aufloesung);
laeng_aufl=round(laenge_teilstuecke/aufloesung);
anzahl_teilstuecke=floor(anz_mp/(vorschub/aufloesung));

% Definition eines Tiefpassfilters fr die Groen Wellenlngen
fc01    = 1/20;
fs    = 1/aufloesung;
[b01,a01] = butter(6,fc01/(fs/2), 'low');

X01(end)=[];
Y01(end)=[];
Y02(end)=[];

Y01_L=Y01-filtfilt(b01, a01, Y01);
Y02_L=Y02-filtfilt(b01, a01, Y02);

m=1;

snc_aufl=round(aufloesung/10,2);
XR00=linspace(0,laenge_teilstuecke,laeng_aufl)';
XRHFL=linspace(0,laenge_teilstuecke,laeng_aufl*10)';

for k=1:anzahl_teilstuecke-1
   
    YR00=Y01_L((k-1)*vors_aufl+1:(k-1)*vors_aufl+laeng_aufl);
    YR01=Y02_L((k-1)*vors_aufl+1:(k-1)*vors_aufl+laeng_aufl);
    
    YRHFL_00=interp1(XR00,YR00,XRHFL,'pchip');
    YRHFL_01=interp1(XR00,YR01,XRHFL,'pchip');
       
    [XCF,LGS]=crosscorr(YRHFL_00,YRHFL_01,'NumLags',floor((size(XRHFL,1)-2)/8));
    [hks_wert,hks_ind]=max(XCF);
    
    if hks_wert>0.6
         xm_tst00(:,m)=X01((k-1)*vors_aufl+1:(k-1)*vors_aufl+laeng_aufl);
         OFFSW(m,:)=LGS(hks_ind)*snc_aufl;
         KFFSW(m,:)=hks_wert;
         m=m+1;
    end
    
end

disp(['Qualitt der Feinsynchronisation: ',num2str(min(KFFSW*100)),' % bis ',num2str(max(KFFSW*100)),' %'])

end

%%% EOF

