
function [Per,Pegel] = Periodizitaet(cWLP,dx,eval_len)
% Periodizitaet.m berechnet den Pegel und die dazugehörige Periodenlänge
% der Periodizität
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

cWLP0 = detrend(cWLP - movmean(cWLP,eval_len));
denom = ones(eval_len,1);                   % biased
% denom = (eval_len - abs(0:eval_len-1))';  % unbiased
%-------------------------
AUTO1 = autocorr(cWLP0,'NumLags',eval_len-1)./denom;
AUTO1 = AUTO1/AUTO1(1);
AUTO1 = AUTO1(1:eval_len);
%--------------------------------------------------------------------------
Index = find(AUTO1>=0);
Posneg = -ones(eval_len,1);
Posneg(Index) = 1;
IP = find(diff(Posneg)>0) + 1;
IN = find(diff(Posneg)<0) + 1;
N = length(IN);
MAX = []; LMAX = [];
MIN = []; LMIN = [];
if N > 1
    for k = 1:N-1
        [M,I] = max(AUTO1(IP(k):IN(k+1)-1));
        MAX(k) = M;
        LMAX(k) = IP(k)+I-1;
        [M,I] = min(AUTO1(IN(k):IP(k)-1));
        MIN(k) = M;
        LMIN(k) = IN(k)+I-1;
    end
else
    [M,I] = max(AUTO1(IP:end));
    MAX = M;
    LMAX = IP+I-1;
    [M,I] = min(AUTO1(IN:IP-1));
    MIN = M;
    LMIN = IN+I-1;
end
[M,I] = max(MAX-MIN);
Pegel = 0.5*M;
Per = dx*LMAX(I);

%%% EOF

