
function [pL] = Sim_Latte(Profil)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Simulation der 4m-Richtlatte
    %   Input: Profil - Höhenlängsprofilwerte [m] in 10cm-Abstand
    %   Output: pL    - Messwerte in Lattenmitte [m] in 10cm-Abstand
%   Version 1.0 
%   16.03.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

ndata = length(Profil);
dx = 0.1;
evl = 40;
evl2 = evl/2;
nj = ndata - evl;

for j = 1:nj
    curr_data = Profil(j:j+evl);
    for i = 1:evl2                  % mögl. Kontaktpunkte vorderer Bereich
        for k = evl2+2:evl+1        % mögl. Kontaktpunkte hinterer Bereich
            a = (curr_data(k)-curr_data(i))/((k-i)*dx);
            b = curr_data(k) - (k-1)*a*dx;
            g = b + a*dx*(0:evl);
            d = g - curr_data;
            id = find(d<-10^-5,1);  % Latte "schneidet" das Profil
            if isempty(id)==1       % Latte liegt auf dem Profil auf
                p(j)=d(evl2+1);
                break
            end
        end
    end
end

% Da die Lattenmitte als Auflagepunkt ausgeschlossen wird (Kippeln möglich)
% kann es in seltenen Fällen zu negativen Werten in Lattenmitte kommen. Das
% Höhenlängsprofil durchstößt dann geringfügig die rechnerische Latte.
% Physikalisch ist das bei der echten Latte nicht möglich. Daher werden
% entsprechende Werte auf "0" gesetzt. 
p(p<0)=0;

% padding Vor- und Nachlauf
np = length(p);
pcr = ndata - np - evl2;
pL = [ones(1,evl2)*p(1) p ones(1,pcr)*p(np)];

%%% EOF

