%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   WLP_Hauptskript.m
    %   Berechnung des WLP sowie der nachgeordneten Kennwerte
%   Version 1.1
%   14.05.2024
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
close all
clear

loc_script=pwd;
loc_data=[loc_script(1:end-25),'Results\'];

[FileName01,PathName01] = uigetfile('*.mat','Importiere synchronisierte Profile aus 01_HLP_SNC',loc_data,'Multiselect','on');
Zielpfad=[PathName01(1:end-11),'02_WLP_DATA\'];
mkdir(Zielpfad)

if isa(FileName01,'char')
    
    disp('Bitte 2 synchronisierte Profile auswählen')

else
    FileNum = size(FileName01,2);

    for dt = 1:FileNum
        
        Quelldatei=FileName01{dt};
        load([PathName01,Quelldatei])
        
        disp(['Computing WLP for ',PathName01(end-16:end),Quelldatei(1:end-4)])
        
        [WLP_Daten,Profilparameter]=wlp_berechnung(REFKOORD,hs,lfm);
        WLP_Daten.loc_Fug_Elim = REFKOORD_Fug_Elim;
        
        matfile1=[Zielpfad,Quelldatei(1:end-11),'WLP_DT','.mat'];
        save(matfile1,'WLP_Daten','Profilparameter');
        disp(['Erzeuge: ',matfile1])
        
        clear REFKOORD
        clear REFKOORD_Fug_Elim
        clear hs
        clear lfm
        clear WLP_Daten
        clear Profilparameter
        
    end
end

%%% EOF

