function data = prepare_Profile(xm,h,shift)
% Symmetrische Erweiterung des Profils um "shift" + 100m-Hochpassfilterung
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% set up moving avering filter (102.5 m) only for visualization of profile
num_ma = 1024;
a_ma = [1 zeros(1, num_ma)];
b_ma = ones(1, num_ma+1)/(num_ma+1);
nex1 = num_ma/2;
nex = nex1 + shift;

% Create Vor-/Nachlauf with "shift" points
Vorlauf    =  2*h(1) - flipud(h(2:nex+1));
Nachlauf   =  2*h(end) - flipud(h(end-nex:end-1));
h_pad = [Vorlauf; h; Nachlauf];
n_pad = size(h_pad,1);
xpadv = xm(1)*ones(shift,1);
xpadh = xm(end)*ones(shift,1);
movavg = filter(b_ma, a_ma, h_pad);

data(:,1) = [xpadv;xm;xpadh];
data(:,2) = h_pad((nex1+1):(n_pad-nex1)); % ohne 100m-Hochpassfilterung
data(:,3) = h_pad((nex1+1):(n_pad-nex1))-movavg(num_ma+1:n_pad);

end

%%% EOF

