
function [WLP_Daten,Profilparameter] = wlp_berechnung(X,Y,LFM)
% wlp_berechnung.m liefert das WLP sowie die zugehrigen Kennwerte im
% vordefinierten Raster (Standardauflsung: 10 cm)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   12.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% Definition der WLP-Parameter
np = 2048;                  % standard sample length for WLP calculation
w = 2.6;                    % reference waviness;
Lmax = 50;                  % maximum wavelength
Lmin = 0.5;                 % minimum wavelength
EVL = 20;                   % evaluation length [m]
dx = 0.1;                   % sampling interval
eval_len = EVL/dx;                  % evaluation length (= data points)
shift = round((np-eval_len)/2);     % starting point of evaluation

% Parameter zur Definition des SBL/DBL-Verhltnisses
ratio_WLP=4;

% Fenster fr die Autokorrelation der lngerwelligen Periodizitten
evallen02 = 1000; % fr die kurzwelligen Periodizitten: eval_len

% Symmetrische Erweiterung des Profils um "shift" + 100m-Hochpassfilterung
data = prepare_Profile(X,Y(:,1),shift);

% Anzahl der Profilabschnitte
num_profiles = floor((size(data,1)-(np-eval_len))/eval_len);

% Vordefinition der Profilvektoren
WLP_all=zeros([num_profiles*eval_len 1]);
h_all=zeros([num_profiles*eval_len 1]);
loc_all=zeros([num_profiles*eval_len 1]);
Plano_all=zeros([num_profiles*eval_len 1]);
WLP_100=zeros([(num_profiles*eval_len+(1000-eval_len)) 1]);

disp('Calculating WLP:')

for i = 1:num_profiles			%Loops begin
    
    if mod(i,25)==0
        disp(['Percent finished:  ',num2str(100*i/num_profiles),' %'])
    end
    
    % Auszug der Daten aus dem Datenvektor
    loc_data1 = data(((i-1)*eval_len+1):((i-1)*eval_len+np),1);
    curr_data = data(((i-1)*eval_len+1):((i-1)*eval_len+np),2);
    hm_data   = data(((i-1)*eval_len+1):((i-1)*eval_len+np),3);
    
    % Berechne WLP
    WLP=wlp_v1(curr_data, eval_len, w, Lmin, Lmax);
    
    % Berechne verlngertes WLP fr Autokorrelation
    WLP20_100 = wlp_v1_100(curr_data, eval_len, w, Lmin, Lmax);
    
    pPlano = Sim_Latte(curr_data');         % der Planograf wird durch eine
    Plano = pPlano(shift+1:shift+eval_len)';% Lattensimulation abgebildet
    
    % entsprechendes Lngsprofil (100m-hochpassgefiltert)
    hm  = hm_data(shift+1:shift+eval_len);
    loc_data  = loc_data1(shift+1:shift+eval_len);

    % stack data    
    WLP_all(eval_len*(i-1)+1:eval_len*i,:)=WLP*1000;    % [mm]
    h_all(eval_len*(i-1)+1:eval_len*i,:)=hm*1000;       % [mm]
    loc_all(eval_len*(i-1)+1:eval_len*i,:)=loc_data;    % [m]
    Plano_all(eval_len*(i-1)+1:eval_len*i,:)=1000*Plano;% [mm]
    
    % verlngertes WLP fr Autokorrelation
    if i == 1
        WLP_100(1:600,1)=1000*WLP20_100(1:600,1); % [mm]
    elseif i == num_profiles
        WLP_100((i-1)*200+401:(i-1)*200+1000,1)=1000*WLP20_100(401:end,1); % [mm]
    else
        WLP_100((i-1)*200+401:(i-1)*200+600,1)=1000*WLP20_100(401:600,1); % [mm]
    end    
end

% Filter (Butterworth) WLP100-Aufschrieb in 2 Bnder
wnS = 0.2/3;                        % normalized cutoff frequency 3m
[bLM,aLM] = butter(1,wnS);
WLP_LM = filter(bLM,aLM,WLP_100);   % contains wavelengths > 3m
WLP_S = WLP_100 - WLP_LM;           % contains wavelengths < 3m

% Calculate Moving SBL/DBL
Nwlp = (num_profiles-1) * eval_len;
% Dreiecksfenster -----------------------------------
Halb = eval_len/2;
hd1 = 1/Halb *(1:Halb); hd2 = 1 - hd1;
Fenster = [hd1 hd2]';
%----------------------------------------------------
Power = sum(Fenster.^2)/sum(ones(eval_len,1).^2);
Vgrf = 1/sqrt(Power); % 1.7320
%----------------------------------------------------

% Definiere Ausgangsgren
SBL_all=zeros([(Nwlp) 1]);
DBL_all=zeros([(Nwlp) 1]);
PEGEL_ROH=zeros([(Nwlp) 1]);
PER = zeros([(Nwlp) 1]);

disp('Calculating Indicators:  ')

for k0 = 1 : Nwlp
    check_Period = 100*k0/Nwlp;    
    if mod(k0,(25*eval_len))==0
        disp(['Percent finished:  ',num2str(check_Period),' %'])
    end
    
    % Beziehe Auszug aus dem WLP-Aufschrieb bzw. WLP100-Aufschrieb
    cWLP    = WLP_all(k0:k0+eval_len-1);
    cWLP_LM = WLP_LM(k0:k0+evallen02-1);
    cWLP_S  = WLP_S(400+k0:400+k0+eval_len-1);

    % Berechnung WLP Kennwerte
    currWLP = Fenster.*cWLP;
    SBL_all(k0,1) = Vgrf * std(currWLP);
    DBL_all(k0,1) = max(currWLP)-min(currWLP);
    
    % Berechnung Periodizittenkennwert
    [Per2,Pegel2] = Periodizitaet(cWLP_LM,dx,evallen02);
    [Per1,Pegel1] = Periodizitaet(cWLP_S,dx,eval_len);

    % Bestimme ausschlaggebende Periodizitt
    Per = [Per1 Per2];
    Pegel = [Pegel1 Pegel2];
    [M,I] = max(Pegel);
    PEGEL_ROH(k0,1)=M;
    PER(k0,1) = Per(I);
    
end

% gltte PEGEL_ROH ber 10m
PEGEL=movmean(PEGEL_ROH,100);

% Teile den DBL-Schrieb durch den Faktor 4 zum Vergleich mit SBL-Schrieb
DBL_all=DBL_all/ratio_WLP;

% Maximum von SBL und DBL/4
SDBL_all = max([SBL_all DBL_all],[],2);

% corresponding Data der Lnge Nwlp fr die Darstellung
WLP_all = WLP_all(eval_len/2+1:eval_len/2+Nwlp);
h_all = h_all(eval_len/2+1:eval_len/2+Nwlp);
loc_all = loc_all(eval_len/2+1:eval_len/2+Nwlp);
lfm_all = LFM(eval_len/2+1:eval_len/2+Nwlp);
Plano_all = Plano_all(eval_len/2+1:eval_len/2+Nwlp);

% Exportsektion
WLP_Daten.WLP_all=WLP_all;
WLP_Daten.h_all=h_all;
WLP_Daten.loc_all=loc_all;
WLP_Daten.lfm_all=lfm_all;
WLP_Daten.Plano_all=Plano_all;
WLP_Daten.SBL_all=SBL_all;
WLP_Daten.DBL_all=DBL_all;
WLP_Daten.SDBL_all = SDBL_all;
WLP_Daten.PEGEL=PEGEL;
WLP_Daten.PER=PER;
Profilparameter.EVL=EVL;
Profilparameter.eval_len=eval_len;
Profilparameter.num_profiles=num_profiles;
Profilparameter.dx=dx;
Profilparameter.Nwlp=Nwlp;

end

%%% EOF

