function pdata=Calculate_p_Mangel(SDBLin,Raster,Tol_schrieb)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   06.04.2023 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       berechnet Stelle und Hhe der berschreitungen ("Manahmenstufe 2")
%       des SDBL- Schriebes
%       Raster  := Rasterlnge [m]
%       SDBLin  := SDBL-Schrieb [mm]
%       Tol_Schrieb := Toleranzgrenze [mm]
%       pdata := Ergebnisvektor = [Stelle [], berschreitung [mm]]
%--------------------------------------------------------------------------
location = SDBLin(:,1);
height  = SDBLin(:,2);

dx = 0.1;               % [m] Schrittweite
nR = Raster/dx;         % [-] Anzahl der Punkte pro Raster
np = length(height);    % [-] Anzahl Datenpunkte insgesamt
NR = floor(np/nR);      % [-] Anzahl der Raster

locr = reshape(location(1:nR*NR),nR,NR);
heir = reshape(height(1:nR*NR),nR,NR);
tolr = reshape(Tol_schrieb(1:nR*NR),nR,NR);

hmax = round(max(heir));
x = round(median(locr));
tol_loc=max(tolr);

index = find(hmax>tol_loc);
Loc = x(index);
Max = hmax(index);
pdata = [Loc;Max]';


%%% EOF

