function pdata = Calculate_p_PER(PERin,Raster,Tol)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   06.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%        berechnet Stelle und Hhe der Toleranzberschreitungen
%        des Pegel-Schriebes
%        Raster := Rasterlnge [m]
%        PERin  := Pegelschrieb [-]
%           Tol := Toleranzgrenze = 0.5
%         pdata := Ergebnisvektor = [Stelle [], berschreitung [-]]
%--------------------------------------------------------------------------
location = PERin(:,1);
height  = PERin(:,2);

dx = 0.1;               % [m] Schrittweite
nR = Raster/dx;         % [-] Anzahl der Punkte pro Raster
np = length(height);    % [-] Anzahl Datenpunkte insgesamt
NR = floor(np/nR);      % [-] Anzahl der Raster

locr = reshape(location(1:nR*NR),nR,NR);
heir = reshape(height(1:nR*NR),nR,NR);
hmax = max(heir);
x = round(median(locr));

index = find(hmax>Tol);
Loc = x(index);
Max = hmax(index);
pdata = [Loc;Max-Tol]';


%%% EOF
