function [pdata,pgr_rec] = Calculate_p_PGR(PGRin,Raster,Tol)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   06.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       berechnet Stelle und Höhe der Toleranzüberschreitungen
%       im PGR-Schrieb
%       Raster  := Rasterlänge [m]
%        PGRin  := 2 Simulationsschriebe [mm]
%           Tol := Toleranzgrenze [mm]
%         pdata := Ergebnisvektor = [Stelle [], Überschreitung [mm]]
%       pgr_rec := PGR-Rechteckfunktion mit Maxima im 2m-Raster
%--------------------------------------------------------------------------
location = PGRin(:,1);
Plano1   = PGRin(:,2);
Plano2   = PGRin(:,3);

dx = 0.1;               % [m] Schrittweite
nR = Raster/dx;         % [-] Anzahl der Punkte pro Raster
np = length(Plano1);    % [-] Anzahl Datenpunkte insgesamt
NR = floor(np/nR);      % [-] Anzahl der Raster

locr = reshape(location(1:nR*NR),nR,NR);
Plano1_r = reshape(Plano1(1:nR*NR),nR,NR);
Plano2_r = reshape(Plano2(1:nR*NR),nR,NR);

Plano1_m = max(Plano1_r);
Plano2_m = max(Plano2_r);

 % Ergebnis = Maximalwert(PGR1,PGR2)
Plano_mw = round(max([Plano1_m;Plano2_m]));
 % Ergebnis = Mittelwert(PGR1,PGR2)
% Plano_mw = round(mean([Plano1_m;Plano2_m]));

hmat = ones(20,1)*Plano_mw;    
pgr_rec = reshape(hmat,[],1);    % Rechteckdarstellung

% Ergebnis der Toleranzwertüberschreitungen im 2m-Raster
x = round(median(locr));
index = find(Plano_mw>Tol);
Loc = x(index);
Max = Plano_mw(index);

pdata= [Loc;Max-Tol]';

%%% EOF

