function [pdata,hrec] = Calculate_p_SDBL(SDBLin,Raster,Tol)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berhrungslose Messungen fr den Bauvertrag
%   Version 1.0
%   06.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%       berechnet Stelle und Hhe der berschreitungen ("Manahmenstufe 1")
%       des SDBL- Schriebes
%       Raster  := Rasterlnge [m]
%           pL  := Simulationsschrieb [mm]
%           Tol := Toleranzgrenze [mm]
%         pdata := Ergebnisvektor = [Stelle [], berschreitung [mm]]
%         h_rec := SDBL-Rechteckfunktion mit Maxima im 2m-Raster
%--------------------------------------------------------------------------
location = SDBLin(:,1);
height =  SDBLin(:,2);

dx = 0.1;               % [m] Schrittweite
nR = Raster/dx;         % [-] Anzahl der Punkte pro Raster
np = length(location);  % [-] Anzahl Datenpunkte insgesamt"
NR = floor(np/nR);      % [-] Anzahl der Raster

locr = reshape(location(1:nR*NR),nR,NR);
heir = reshape(height(1:nR*NR),nR,NR);

hmax = round(max(heir));
%-----------------------------------------
hmat = ones(20,1)*hmax;    % Rechteck-
hrec = reshape(hmat,[],1); % darstellung
%-----------------------------------------

% Ergebnis der Toleranzwertberschreitungen im 2m-Raster
x = round(median(locr));
index = find(hmax>Tol);
Loc = x(index);
Max = hmax(index);

pdata= [Loc;Max-Tol]';


%%% EOF

