
function Mangelgw_lin=per_abschnitte(loc_all,PEGEL,Raster)
%PER_ABSCHNITTE Definiere die Grenzwerte für Mängelbeseitigung infolge von
%Periodizitäten
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   TP Eben - Berührungslose Messungen für den Bauvertrag
%   Version 1.0
%   06.04.2023
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

GW_Mangel_stoch=9;
GW_Mangel_per=5;
L_per_minimum=30;
L_per_maximum=120;
PGL_min=0.5;
PGL_max=0.65;


% Finde die Bereiche in denen (per Definition) Periodizitäten auftauchen
period_sect=find(PEGEL>PGL_min);

% Für den Fall dass ein konstanter Wert (9) verwendet werden soll:
%period_sect=[];

if ~isempty(period_sect)
    
    Delta_GW=GW_Mangel_stoch-GW_Mangel_per;
    
    % Finde zusammenhängende Streckenabschnitte mit Periodizitäten im
    % Pegelschrieb
    
    ind_abschn_trial=find(diff(period_sect)>1);
    anz_abschn=size(ind_abschn_trial,1)+1;
    Abschnitte=zeros([anz_abschn 2]); % [von  bis]
    
    abschnittsindizes(:,1)=[1;ind_abschn_trial+1]; % von ...
    abschnittsindizes(:,2)=[ind_abschn_trial;size(period_sect,1)];%... bis
    Abschnitte(:,1)=loc_all(period_sect(abschnittsindizes(:,1))); % von [m]
    Abschnitte(:,2)=loc_all(period_sect(abschnittsindizes(:,2))); % bis [m]
    
    LG_Abschnitte=Abschnitte(:,2)-Abschnitte(:,1);
    
    % Berechne den Einfluss der Streckenlänge auf die Grenzwertermittlung
    Streckeneinfluss=(LG_Abschnitte-L_per_minimum)/(L_per_maximum-L_per_minimum);
    Streckeneinfluss(Streckeneinfluss<0)=0;
    Streckeneinfluss(Streckeneinfluss>1)=1;
    
    Streckenfaktor=zeros([size(PEGEL,1) 1]);
    for k=1:size(Streckeneinfluss,1)
        Streckenfaktor(period_sect(abschnittsindizes(k,1):abschnittsindizes(k,2)))=Streckeneinfluss(k);
    end
    
    % Berechne den Einfluss der Höhe des Pegels auf die Grenzwertermittlung
    Pegelfaktor=(PEGEL-PGL_min)/(PGL_max-PGL_min);
    Pegelfaktor(Pegelfaktor<0)=0;
    Pegelfaktor(Pegelfaktor>1)=1;
    
    % Berechne den Grenzwertverlauf auf dem 10-cm Schrieb
    Mangelgw_all=GW_Mangel_stoch - Streckenfaktor.*Pegelfaktor*Delta_GW;
    
    % Überführe den Grenzwertverlauf auf einen 2-m Schrieb (gem. Raster)
    rasterpunkte=find(rem(round(loc_all,1),Raster)==0);
    
    Mangelgw_lin=zeros([size(Mangelgw_all,1) 1]);
    % Vereinfache den Grenzwert für Mängel auf Ganzzahlige Werte und auf
    % ein 2-m Raster
    for m=1:size(rasterpunkte,1)-1
        Mangelgw_lin(rasterpunkte(m):rasterpunkte(m+1)-1,:)=round(max(Mangelgw_all(rasterpunkte(m):rasterpunkte(m+1)-1,:)));
    end    
    Mangelgw_lin(rasterpunkte(end):end,:)=round(max(Mangelgw_all(rasterpunkte(end):end)));
    
else
    
    Mangelgw_lin=ones([size(PEGEL,1) 1])*9;
   
end

end

%%% EOF

